<?php

namespace App\Models\Vehicule;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vehicule extends Model 
{

    protected $table = 'vehicules';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function chauffeur()
    {
        return $this->belongsTo('App\Models\Chauffeur\Chauffeur');
    }

    public function modele()
    {
        return $this->belongsTo('App\Models\Modele\Modele');
    }

    public function type_vehicule()
    {
        return $this->belongsTo('App\Models\TypeVehicule\TypeVehicule');
    }

    public function vehicule_offres()
    {
        return $this->hasMany('App\Models\VehiculeOffre\VehiculeOffre');
    }

    public function vehicule_zones()
    {
        return $this->hasMany('App\Models\VehiculeZone\VehiculeZone');
    }

}